@push('script')
<script>
    function setCookie(name, value, days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        const expires = days ? "; expires=" + date.toUTCString() : "";
        document.cookie = `${name}=${value}${expires}; path=/`;
    }

    function getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        return parts.length === 2 ? parts.pop().split(';').shift() : null;
    }

    function acceptCookiePolicy() {
        setCookie("cookie_policy_accepted", "true", 365);
        document.getElementById("cookiesAlert").style.display = "none";
    }

    function closeCookieBanner() {
        document.getElementById("cookiesAlert").style.display = "none";
    }

    document.addEventListener('DOMContentLoaded', function () {
        if (!getCookie("cookie_policy_accepted")) {
            document.getElementById("cookiesAlert").style.display = "block";
        }
    });
</script>
@endpush
<div class="cookies-alert" id="cookiesAlert">
    <img src="{{asset('frontend/images/icons/cookie.png')}}" height="100" width="100" alt="BD Adventure Tour cookies">
    <h4>We Use Cookies!</h4>
    <span class="d-block">We use cookies to ensure that give you the best experience on your website. <br>
    <a href="/cookie-policy" class="btn">See more</a>
    </span>
    <a href="javascript:void(0);" class="mt-3 btn-1 justify-content-center" type="button" onclick="acceptCookiePolicy()">Accept <span></span></a>
    <a href="javascript:void(0);" class="mt-2 btn-2" type="button" onclick="closeCookieBanner()">Close <span></span></a>
</div>
